﻿uses
  Common, DataEntry, DataStorage, Regex, SysUtils;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
var
  theFileDriverInfo: TFileTypeInformation;
begin
  Result := -1; // Exclude
  if assigned(anEntry) then
  begin
    theFileDriverInfo := anEntry.FileDriverInfo;
    if (theFileDriverInfo.ShortDisplayName <> null) and (trim(theFileDriverInfo.ShortDisplayName) <> '') then
    begin
      if dtArchive in theFileDriverInfo.DriverType then
      begin
        theFileDriverInfo := anEntry.DeterminedFileDriverInfo;
        if (theFileDriverInfo.ShortDisplayName <> null) and (trim(theFileDriverInfo.ShortDisplayName) <> '') then
        begin
          if dtArchive in theFileDriverInfo.DriverType then
          begin
            // Exclude by extension
            if RegexMatch(theFileDriverInfo.ShortDisplayName, '^Zip|7zip|TAR|Rar|Thumb', False) then
            begin
              if not RegexMatch(anEntry.EntryNameExt, 'accdt|apk|bau|bbfw|dat|eftx|glox|ipa|ipsw|jar|odb|odg|odp|otp|ots|ott|oxt|rbf|skin|sob|stw|thmx|thmx|ui|wmz|xpi|wmf', False) then // noslz
              begin
                Result := 1; // Include
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;

begin

end.
